/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.client.particle.ArcParticle;
import cofh.core.client.particle.BlastWaveParticle;
import cofh.core.client.particle.FrostParticle;
import cofh.core.client.particle.MistParticle;
import cofh.core.client.particle.PlasmaBallParticle;
import cofh.core.client.particle.ShockwaveParticle;
import cofh.core.client.particle.SparkParticle;
import cofh.core.client.particle.WindSpiralParticle;
import cofh.core.client.particle.WindVortexParticle;
import cofh.lib.client.model.DynamicFluidContainerModel;
import cofh.lib.item.IColorableItem;
import cofh.lib.util.references.CoreReferences;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoreClientSetupEvents {
    private static final List<Item> COLORABLE_ITEMS = new ArrayList<Item>();

    private CoreClientSetupEvents() {
    }

    @SubscribeEvent
    public static void colorSetupItem(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        for (Item colorable : COLORABLE_ITEMS) {
            colors.m_92689_(((IColorableItem)colorable)::getColor, new ItemLike[]{colorable});
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("cofh_core", "dynamic_fluid"), (IModelLoader)new DynamicFluidContainerModel.Loader());
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        ParticleEngine manager = Minecraft.m_91087_().f_91061_;
        manager.m_107378_((ParticleType)CoreReferences.FROST_PARTICLE, FrostParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreReferences.SPARK_PARTICLE, SparkParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreReferences.PLASMA_PARTICLE, PlasmaBallParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreReferences.SHOCKWAVE_PARTICLE, ShockwaveParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreReferences.BLAST_WAVE_PARTICLE, BlastWaveParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreReferences.VORTEX_PARTICLE, WindVortexParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreReferences.SPIRAL_PARTICLE, WindSpiralParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreReferences.STRAIGHT_ARC_PARTICLE, ArcParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreReferences.MIST_PARTICLE, MistParticle::iceMist);
    }

    public static void addColorable(Item colorable) {
        if (colorable instanceof IColorableItem) {
            COLORABLE_ITEMS.add(colorable);
        }
    }
}

